#!/usr/bin/python
#-------------------------------------------------------------------------------
# Name:        Pi-Intercom.py
# Purpose:     Sip Intercom with RaspberryPi and PJSUA
# Note:        A running Asterisk server is required.
#              
# Author:      Carl Fortin
#
# Created:     17-09-2017
# Copyright:   (c) Carl 2017
#-------------------------------------------------------------------------------
import ConfigParser
import RPi.GPIO as GPIO
import sys
import os
import signal
import pjsua as pj
import threading
import subprocess
import time
import signal

# Logging to track events
import logging
from logging.handlers import RotatingFileHandler
from time import sleep
from datetime import datetime 
from asterisk.ami import AMIClient
from asterisk.ami import SimpleAction
import socket



def logger_set_up():
    global logger
    logger = logging.getLogger()
    # Set logger level
    logger.setLevel(logging.DEBUG)
    formatter = logging.Formatter('%(asctime)s:%(levelname)s:%(message)s')
    # Write log to file 'append', max filesize  1Mo
    log_path = '/home/pi/Intercom/Pi-Intercom.log'
    file_handler = RotatingFileHandler(log_path , 'a', 1000000, 1)
    # Use formatter for file
    file_handler.setLevel(logging.DEBUG)
    file_handler.setFormatter(formatter)
    logger.addHandler(file_handler)
    # Redirect each log entry  to console
    steam_handler = logging.StreamHandler()
    steam_handler.setLevel(logging.DEBUG)
    logger.addHandler(steam_handler)

# Logging callback
def log_cb(level, str, len):
    print str,


def signal_handler(signal, frame):
    if call_state.account is not None:
        call_state.account.delete()
        call_state.account = None
    if call_state.lib is not None:
        call_state.lib.destroy()
        call_state.lib = None
    GPIO.cleanup()
    sys.exit(0)


# This function will originate a call from a phone 2005 automatically without lifting the handset
# and call the paging station currently pushing the button
def originate_call():
    print("Originating a call")
    client = AMIClient(address=SIP_DOMAIN,port=5038)
    client.login(username='Auto_Dialer',secret='sknfd67sndoasd8no89hdsfas')
    action = SimpleAction(
    'Originate',
    Channel='PJSIP/2005' ,
    Exten=SIP_USRNM,
    Priority=1,
    Context='internal',
    Variable='PJSIP_HEADER(add,Call-Info)=\;answer-after=0")',
    CallerID='Paging all',
    )
    client.send_action(action)
    client.logoff()
    
class audio_Settings:
    """Class that will set audio and record level """
    
    
    
    # Constructor
    def __init__(self):
        print("Setting audio")
        # Read settings from ini file
        self.settings = ConfigParser.ConfigParser()
        self.settings.read('settings.ini')
        # Audio settings
        self.DEFAULT_MIC = self.settings.get('Audio_Settings', 'DEFAULT_MIC')
        self.MIC_LEVEL = float(self.settings.get('Audio_Settings', 'MIC_LEVEL'))
        self.DEFAULT_PLAYBACK_LEVEL = self.settings.get('Audio_Settings', 'DEFAULT_PLAYBACK_LEVEL')
        self.DEFAULT_RECORD_LEVEL = self.settings.get('Audio_Settings', 'DEFAULT_RECORD_LEVEL')
        self.DEFAULT_PLAYBACK_CARD = self.settings.get('Audio_Settings', 'DEFAULT_PLAYBACK_CARD')
        self.DEFAULT_PLAYBACK_CONTROL = self.settings.get('Audio_Settings', 'DEFAULT_PLAYBACK_CONTROL')
        self.DEFAULT_MIC_CONTROL = self.settings.get('Audio_Settings', 'DEFAULT_MIC_CONTROL')
        # Set up audio level upon class is instantiation
        self.Set_Record_Level(self.DEFAULT_MIC,self.DEFAULT_MIC_CONTROL,self.DEFAULT_RECORD_LEVEL)
        self.Set_Playback_Level(self.DEFAULT_PLAYBACK_CARD,self.DEFAULT_PLAYBACK_CONTROL,self.DEFAULT_PLAYBACK_LEVEL)
        
    #  Function to set volume of playback device. Run aplay -l to know the card number and amixer to know the name of the control
    #  This will set the audio level like seen with the command alsamixer (-M)
    def Set_Playback_Level(self,card_no,control_name,vol_percent):
        try:
            cmd = 'amixer -c%s set -M %s %s%%' %(card_no,control_name,vol_percent)
            proc=subprocess.Popen(cmd, stdout=subprocess.PIPE,stderr=subprocess.PIPE,shell=True) 
            (cmd_out, cmd_err) = proc.communicate()
            
            # If error is found amixer will output Unable to find
            if  cmd_err.find('Unable to find') != -1:
                logger.error("Could not set playback level")
            if cmd_out.find('Simple mixer control') != -1:
                logger.info("Playback level set sucessfully at %s" %vol_percent)
        except IOError as error:
           logger.error("Could not set playback level")
           
    #  Function to set record level. Run arecord -l to know the card number and amixer to know the name of the control
    #  This will set the audio level like seen with the command alsamixer (-M)
    def Set_Record_Level(self,card_no,control_name,vol_percent):
        try:
            cmd = 'amixer -c%s set %s -M %s%%' %(card_no,control_name,vol_percent)
            proc=subprocess.Popen(cmd, stdout=subprocess.PIPE,stderr=subprocess.PIPE,shell=True) 
            (cmd_out, cmd_err) = proc.communicate()
            
            # If error is found amixer will output Unable to find
            if  cmd_err.find('Unable to find') != -1:
                logger.error("Could not set record level")
            if cmd_out.find('Simple mixer control') != -1:
                logger.info("Record level set sucessfully at %s" %vol_percent)
        except IOError as error:
           logger.error("Could not set Record level")
        
    
     
def push_button():
    try:
        # Push sw active low
        if GPIO.input(37) == 0:
           #print("SW ON")
           return True
           
        if GPIO.input(37) == 1:
           #print("SW OFF") 
           return False
             
        
    except:
        return False
        logger.warning("Input sw problem.")
    

# Call the remote intercom
def call_intercom():
            
            
# If button is pushed and there's no active call, call the remote station
            if push_button() and call_state.call_current_state == 0 and call_state.outgoing_calling_flag == 0 and call_state.incoming_calling_flag == 0:
               
               logger.info("Calling...")
               # Check number of keypress
               number_of_keypress = detect_key_press()
               # Reset call timeout value
               call_state.time_out = time.time() + int(CALL_TIMEOUT)
                
               if number_of_keypress == 1:
                   # Make call to 1 intercom
                   call_state.outgoing_calling_flag = 1
                   call_state.current_call = call_state.account.make_call("sip:"+ str(REMOTE_PAGING_STATION)+"@"+str(SIP_DOMAIN), MyCallCallback())
                   print("Calling Intercom " +  str(call_state.current_call))  
                                  
                   
               if number_of_keypress == 2:
                   # Make call to many intercoms
                   #call_state.outgoing_calling_flag = 1
                   originate_call()
                   #call_state.current_call = call_state.account.make_call("sip:"+ str(PAGING_ALL_STATION)+"@"+str(SIP_DOMAIN), MyCallCallback())
                   print("Calling All ")
                   
               if number_of_keypress >= 3:

                    logger.error("Too many keypress!")     

               

# Talk to remote intercom while on an active call
def talk_to_intercom():

# If button is pushed and there's an active call unmute the mic
            if push_button() and call_state.call_current_state == 1 :
                
                try:
                        print( "Talking to " + str(call_state.current_call))
                        # Reset call timeout value
                        call_state.time_out = time.time() + int(CALL_TIMEOUT)
                        # UnMute Mic if button is pressed
                        call_state.lib.conf_set_tx_level(call_slot, audio.MIC_LEVEL)
                
                        # Force Hangup if button is pushed 2 times during an active call                     
                        number_of_keypress = detect_key_press()
                        if number_of_keypress == 2:
                              call_state.current_call.hangup()
                              call_state().clear_call_flag()
                              logger.info("Manual hangup")
                        # Wait while button is pushed
                        else:
                                                               
                               while push_button():
                                   sleep(0.005)    
                               # Mute Mic
                               call_state.lib.conf_set_tx_level(call_slot, 0)
                                
                except Exception as e:
                        logger.error("Error, no calls in progress:" + str(e))   
    
# Detect the number of times the button was pushed
# Return 1 if keypress was pushed longer than 0.5 seconds
def detect_key_press():
    number_of_push = 0
    start_time = time.time()
    last_push_time = start_time
    time_between_keypress = 0.700
    try:
        
            # Check for keypress as long as the time between the keypress is less than 0.700 seconds
            while (time.time() - last_push_time) <= time_between_keypress:
               sleep(0.020)          
               
               if push_button():
                   time_now_1 = time.time()
                   # While button is pushed and it's under 0.7 seconds 
                   while push_button() and (time.time() - time_now_1) <= time_between_keypress:
                            sleep(0.020)
                   
                   # Check how long the button was hold on.
                   pushed_time = time.time() - time_now_1
                   print("Push_time: " + str(pushed_time))
                   
                   # Increment the number of push
                   number_of_push = number_of_push + 1
                   
                   # Check the elapsed time between keypress
                   time_between_presses = time.time() - last_push_time
                   #if number_of_push > 1:
                   #   print("Push button " +  str(number_of_push) + " Time elapsed: " + str(time_between_presses))                   
                   #last_push_time = time.time()
                                        
            return number_of_push
        
                 
            
    except:
        return 0
        logger.warning("Detect problem while checking for the number of time the button was pushed.")                    


                        
# Auto answer call
def auto_answer(call):
    sleep(0.5)
    call.answer(200)

    
# Blinking LED to indicates that program is running
def Standby_Blinking_Led():
    
    try:
        while not stop_blinking_led_now:
        
            # Blink standby
            if call_state.call_current_state == 0:
                GPIO.output(36, GPIO.HIGH)
                sleep(1)
                GPIO.output(36, GPIO.LOW)
                sleep(1)
                
            # Led is on  
            if call_state.call_current_state == 1:
                GPIO.output(36, GPIO.HIGH)
                # Avoid 100% CPU on raspberry pi
                sleep(0.100)
               
            
                    
    except KeyboardInterrupt:
           print("Exit led thread")
           thread.interrupt_main()
           
# Check if the call must be hangup when the caller
# has not activated the button for more than the CALL_TIMEOUT
def check_call_activity():
            
            # Hangup the call if no activity has been detected
            if time.time() >= call_state.time_out and call_state.call_current_state == 1:
               try:
                   # Check if it's the callee 
                   #if str(call_state.current_call.info().role) == "0":
                       call_state.current_call.hangup()
                       call_state().clear_call_flag()
                       logger.info("No activity, hanging up...")
                       
                   #else:
                   
                       #pass
                 
               except Exception as e:
                   call_state().clear_call_flag()
                   logger.warning("Error, no calls to hangup" + str(e))
                   
            else: 
               pass 

               
def set_preferences():
    global CALL_TIMEOUT
    global REMOTE_PAGING_STATION
    global PAGING_ALL_STATION
    
    
    # Read settings from ini file
    settings = ConfigParser.ConfigParser()
    settings.read('settings.ini')
        
    REMOTE_PAGING_STATION = settings.get('Sip_Settings', 'REMOTE_PAGING_STATION')
    PAGING_ALL_STATION = settings.get('Sip_Settings', 'PAGING_ALL_STATION')
    CALL_TIMEOUT = settings.get('Audio_Settings', 'CALL_TIMEOUT')
             
    logger.info("Preferences set.")             
               
def set_my_GPIO():

    GPIO.setmode(GPIO.BOARD)
    # Push button active low
    GPIO.setup(37, GPIO.IN,pull_up_down=GPIO.PUD_UP)
    # Led
    GPIO.setup(36, GPIO.OUT) 
               

  
               
def Init_And_Register():
       
        global SIP_DOMAIN
        global SIP_USRNM
        # Read settings from ini file
        settings = ConfigParser.ConfigParser()
        settings.read('settings.ini')
    
        # Sip settings Domain,username,password
        SIP_DOMAIN = settings.get('Sip_Settings', 'SIP_DOMAIN')
        SIP_USRNM = settings.get('Sip_Settings', 'SIP_USRNM')
        SIP_PWD = settings.get('Sip_Settings', 'SIP_PWD')
        
        LOG_LEVEL = 0
               
        # Create library instance
        call_state.lib = pj.Lib()
        my_ua_cfg = pj.UAConfig()
        my_ua_cfg.user_agent = "Intercom_" + str(SIP_USRNM)
        my_ua_cfg.max_calls = 1
        MediaConfig = pj.MediaConfig()
        MediaConfig.no_vad = False
        #MediaConfig.snd_clock_rate  = 16000
        #MediaConfig.clock_rate  = 16000
        MediaConfig.quality = 8
        MediaConfig.ec_options = 0
        MediaConfig.ec_tail_len = 256
        # Init PJ library              
        call_state.lib.init(log_cfg = pj.LogConfig(level=LOG_LEVEL, callback=log_cb),ua_cfg=my_ua_cfg,media_cfg = MediaConfig)
        call_state.lib.create_transport(pj.TransportType.UDP, pj.TransportConfig(5080))
        call_state.lib.start()
        
                        
        # Create account    
        call_state.account = call_state.lib.create_account(pj.AccountConfig(SIP_DOMAIN, SIP_USRNM, SIP_PWD))
        acc_cb = MyAccountCallback(call_state.account)
        call_state.account.set_callback(acc_cb)
        acc_cb.wait()
        
        # Check registration status
        registration_status = str(call_state.account.info().reg_status) + str(call_state.account.info().reg_reason)
        if  registration_status == "401Unauthorized":
            logger.error("Error, Intercom not registered, check settings.ini")
            call_state.lib.destroy()
            sys.exit(0)
        if registration_status == "408Request Timeout":
            logger.error("Error, Timeout registering with " + str(SIP_DOMAIN) + " , check settings.ini")
            call_state.lib.destroy()
            sys.exit(0)
        if registration_status == "200OK":
           logger.info("Registration sucessful with " + str(SIP_DOMAIN))
        else:
           logger.info("Registration problem with " + str(SIP_DOMAIN))
           call_state.lib.destroy()
           sys.exit(0) 


               
# Flags that indicates call status       
class call_state(object):
    print("class object")
    call_current_state = 0 
    outgoing_calling_flag = 0
    incoming_calling_flag = 0
    time_out = 0
    current_call = None
    lib = None
    account = None
    
    # Clear all flags
    def clear_call_flag(self):
       call_state.outgoing_calling_flag = 0
       call_state.incoming_calling_flag = 0
       call_state.call_current_state = 0
       call_state.current_call = None
    
# Callback to receive events from account
class MyAccountCallback(pj.AccountCallback):
    sem = None

    def __init__(self, account=None):
        pj.AccountCallback.__init__(self, account)

    def wait(self):
        self.sem = threading.Semaphore(0)
        self.sem.acquire()

    def on_reg_state(self):
        if self.sem:
            if self.account.info().reg_status >= 200:
                self.sem.release()

    # Notification on incoming call
    def on_incoming_call(self, call):
         
        if call_state.current_call:
            call.answer(486, "Busy")
            return
        print("Incoming call")    
        # Set flag that indicates that another intercom is calling
        call_state.incoming_calling_flag = 1
        call_state.current_call = call
        call_cb = MyCallCallback(call_state.current_call)
        call_state.current_call.set_callback(call_cb)
                
        
        try:
            if call_state.call_current_state == 0:
                auto_answer(call_state.current_call)
            else:
                logger.error("Could not auto-answer call already in use")
        except pj.Error, e:
            logger.error("Could not auto-answer call:" + str(e) )
            return None

       
# Callback to receive events from Call
class MyCallCallback(pj.CallCallback):

    def __init__(self, call=None):
        pj.CallCallback.__init__(self, call)

    # Notification when call state has changed
    def on_state(self):
                
        
        # Uncomment this line for debugging
        # logger.info("Call with " + self.call.info().remote_uri + " is " + self.call.info().state_text)
        
        # Advise that the outgoing call has failed       
        if self.call.info().state_text == "DISCONNCTD" and call_state.outgoing_calling_flag == 1 and  call_state.call_current_state == 0 and self.call.info().remote_uri == "sip:"+str(REMOTE_PAGING_STATION+"@"+SIP_DOMAIN) :
                      call_state.call_current_state = 0
                      logger.warning("Call to " + str(REMOTE_PAGING_STATION) +" intercom failed!")
                      # Beep tone ,indicating that remote intercom is not answering
                      os.system('aplay  /home/pi/Intercom/beep-error.wav')
        
        
        
        # Check if the incomming call was answered corectly  by checking if we are the callee    
        if self.call.info().state_text == "CONFIRMED" and call_state.incoming_calling_flag == 1:
                     print("Incoming call answered from " + str(self.call.info().remote_uri))        
                     #logger.info("Incoming call answered from " + str(self.call.info().remote_uri))
                     call_state.call_current_state = 1
                     call_state.incoming_calling_flag = 0
                     # Reset inactivity timer
                     call_state.time_out = time.time() + int(CALL_TIMEOUT)
                     # If caller id is "Paging all" double beep to indicate that we pushed the button twice
                     if "Paging all" in str(self.call.info().remote_uri):
                          os.system('aplay /home/pi/Intercom/double_beep.wav')
                     # Otherwise one beep                          
                     else:
                          # Beep tone indicating that we can start talking
                          os.system('aplay /home/pi/Intercom/single_beep.wav')
        
        
        
        if self.call.info().state == pj.CallState.DISCONNECTED:
            logger.info("Call was disconnected")
            call_state().clear_call_flag()
            
    

    # Notification when call's media state has changed.
    def on_media_state(self):
        try:
            if self.call.info().media_state == pj.MediaState.ACTIVE:
                print("Media is active")
                # Connect the call to sound device
                global call_slot
                call_slot = self.call.info().conf_slot
                # If bidirectional media flow is desired,
                # application needs to call this function twice, with the second one having the arguments reversed.
                pj.Lib.instance().conf_connect(call_slot, 0)
                pj.Lib.instance().conf_connect(0, call_slot)
                # Mute Mic on first call 
                pj.Lib.instance().conf_set_tx_level(call_slot, 0)
                
                
                
                # Check if remote intercom has answered the call by checking if we are calling and we are the caller
                call_answered =  str(self.call.info().state_text) + (str(self.call.info().last_code) + str(self.call.info().last_reason))
                
                if call_answered == "CONFIRMED200OK" and call_state.outgoing_calling_flag == 1 and str(self.call.info().role) == "0":
                      print("Outgoing call to " + str(self.call.info().remote_uri) + " is answered")
                      #logger.info("Outgoing call to " + str(self.call.info().remote_uri) + " is answered")
                      # Reset inactivity timer
                      call_state.time_out = time.time() + int(CALL_TIMEOUT)
                      call_state.call_current_state = 1
                      call_state.outgoing_calling_flag = 0
                      # Beep tone indicating that we can start talking
                      os.system('aplay /home/pi/Intercom/single_beep.wav')
                      
                                                     
                
            else:
                logger.info("Media is now inactive.")
        except pj.Error, e:
                logger.error("Pjsip error active call:" + str(e) )
                call_state().clear_call_flag()
                if not call_state.current_call:
                    print "There is no call"
                return
                
      
        
def main():                
    call_state.lib = None
    call_state.account = None
    global stop_blinking_led_now
    global audio
    # Variable to cleanly exit a thread by keyboard intterupt
    stop_blinking_led_now = False
      
    # Setup logging
    logger_set_up()    
    logger.info("Intercom PI starting...")       
         
    # Call state object to indicate call status
    call_state()     
    
    # Read settings from ini file
    set_preferences()
    
    # Set playback and record audio level    
    audio = audio_Settings()
        
    # Set up GPIO
    set_my_GPIO()
    
    
    try:
        
        # Init PJSIP and register endpoints
        Init_And_Register()
                       
        # Blinking LED to indicate that program is running
        flashing_thread = threading.Thread(target=Standby_Blinking_Led)
        # Start thread and make the thread stop on keyboard interrupt
        flashing_thread.start()
                      
           
        while True:
          
          try:
            # Avoid 100 % CPU on raspberry pi
            sleep(0.005)
          
            # Talk to remote intercom if call is active
            talk_to_intercom()
            
            # Call the remote intercom
            call_intercom()        
             
            # Hangup the call if no activity has been detected     
            check_call_activity()
            
    
          except KeyboardInterrupt:
                 if call_state.current_call is not None:
                     call_state.current_call.hangup()
                 if call_state.account is not None:
                   call_state.account.delete()
                   call_state.account = None
                 if call_state.lib is not None:
                   call_state.lib.destroy()
                   call_state.lib = None
                 #Clean way of stopping the thread
                 stop_blinking_led_now = True
                 GPIO.cleanup()
                 logger.warning("Exited by keyboard interrupt!")
                 sys.exit(0)
        
        signal.signal(signal.SIGINT, signal_handler)
        signal.pause()
    
        call_state.account.delete()
        call_state.account = None
        call_state.lib.destroy()
        call_state.lib = None
    
    except pj.Error, e:
        logger.error("Pjsip error:" + str(e) )
        if call_state.account is not None:
            call_state.account.delete()
            call_state.account = None
        if call_state.lib is not None:
            call_state.lib.destroy()
            call_state.lib = None
    
    
        
if __name__ == '__main__':
    
    main()
    
        
    
    
            
        